<?php
// app/bootstrap.php
// jednoduchý autoloader + helpery pro projekt

// Autoloader pro namespace App\ -> mapuje na adresář app/
spl_autoload_register(function ($class) {
    $prefix = 'App\\';
    $base_dir = __DIR__ . '/';
    $len = strlen($prefix);

    // pokud není naše jmenný prostor, nic neuděláme
    if (strncmp($prefix, $class, $len) !== 0) {
        return;
    }

    // relativní část jména třídy
    $relative_class = substr($class, $len);

    // zaměnit namespace separator za directory separator
    $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';

    if (file_exists($file)) {
        require $file;
    }
});

// helper funkce pro získání konfigurace (načítá app/config.php jednou)
function config(): array
{
    static $cfg = null;
    if ($cfg === null) {
        $cfgFile = __DIR__ . '/config.php';
        if (!file_exists($cfgFile)) {
            throw new \RuntimeException('Konfigurační soubor nenalezen: ' . $cfgFile);
        }
        $cfg = require $cfgFile;
    }
    return $cfg;
}